<!DOCTYPE html>
<html lang="pt-br">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $__env->yieldContent('pageTitle', "Admin Dashboard"); ?></title>

    <link rel="stylesheet" href="<?php echo e(asset('admin/css/bootstrap.css')); ?>">

    <link rel="stylesheet" href="<?php echo e(asset('admin/vendors/simple-datatables/style.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('admin/vendors/perfect-scrollbar/perfect-scrollbar.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('admin/css/app.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('admin/vendors/chartjs/Chart.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(mix('admin/css/custom-dashboard.css')); ?>">

    <?php echo $__env->yieldContent('styles'); ?>

    <link rel="shortcut icon" href="<?php echo e(asset('images/favicon.ico')); ?>" type="image/x-icon">
</head>
<body>
<div id="app">

    <?php echo $__env->make('sweetalert::alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->make('layouts.admin._includes._sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div id="main">
        <?php echo $__env->make('layouts.admin._includes._navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="main-content container-fluid">
            <div class="page-title">
                <h3><?php echo $__env->yieldContent('pageTitle', ""); ?></h3>
                <p class="text-subtitle text-muted"><?php echo $__env->yieldContent('pageSubTitle', ""); ?> </p>
            </div>

            <?php echo $__env->yieldContent('conteudo'); ?>

            <?php echo $__env->make('layouts.admin._includes._footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        </div><!-- /main-conttent -->
    </div><!-- /main -->
</div><!-- /app -->





<script src="<?php echo e(asset('admin/js/feather-icons/feather.min.js')); ?>"></script>
<script src="<?php echo e(asset('admin/vendors/perfect-scrollbar/perfect-scrollbar.min.js')); ?>"></script>
<script src="<?php echo e(asset('admin/js/app.js')); ?>"></script>

<script src="<?php echo e(asset('admin/vendors/simple-datatables/simple-datatables.js')); ?>"></script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/tinymce/4.9.5/tinymce.min.js" referrerpolicy="origin"></script>



<?php echo $__env->yieldContent('scripts'); ?>

<script src="<?php echo e(asset('admin/js/main.js')); ?>"></script>

</body>

</html>
<?php /**PATH /home/eticon/public_html/webservice/resources/views/layouts/admin/admin.blade.php ENDPATH**/ ?>