<div>

    <h4 class="font-weight-lighter"><ion-icon name="caret-forward-outline"></ion-icon> Agências Financeiras</h4>
    <div class="alert alert-light">
        Agências cadastradas para o envio dos balecetes.
    </div>

    <hr>

    <div class="card-body">

        <a href="{{ route('instituicaoFinanceira.index') }}"
            type="button"
            class="btn btn-info mb-lg-5"
        >
            <ion-icon name="arrow-back-outline"></ion-icon> Início
        </a>

        <button
            type="button"
            class="btn btn-success mb-lg-5"
            data-bs-toggle="modal"
            data-bs-target="#createAgenciaModal"
            wire:click="$emit('abrirCreateAgenciaModal')"
        >
            <ion-icon name="add-circle-outline"></ion-icon> Cadastrar uma nova Agência
        </button>

        <div class="table-responsive">
            <table id="start_datatable" class="table table-striped">
                <thead class="thead-light">
                <tr>
                    <th>Empresa</th>
                    <th>Nome</th>
                    <th>Código</th>
                    <th>CNPJ</th>
                    <th>Observações</th>
                    <th>Status</th>
                    <th class="text-end">Ações</th>
                </tr>
                </thead>
                <tbody>
                @forelse($agencias as $agencia)
                <tr>
                    <td class="align-middle">{{ $agencia->instituicaoFinanceira->nome ?? "-" }}</td>
                    <td class="align-middle">{{ $agencia->nome }}</td>
                    <td class="align-middle">{{ $agencia->codigo }}</td>
                    <td class="align-middle">{{ $agencia->cnpj }}</td>
                    <td class="align-middle">{{ $agencia->observacoes }}</td>
                    <td class="text-center align-middle"><x-status-padrao :status="$agencia->status" /></td>
                    <td class="text-end">

                        <div class="btn-group">

                            <button
                                type="button"
                                class="btn btn-outline-primary"
                                title="Editar"
                                data-bs-toggle="modal"
                                data-bs-target="#updateAgenciaModal"
                                wire:click="$emit('abrirEditAgenciaModal', '{{ $agencia->uuid }}')"
                            >
                                <ion-icon name="create-outline"></ion-icon> Editar
                            </button>

                            <!-- Exibir apenas se não houver lançamentos para a agência -->

                            @if($agencia->balancetes->count() === 0)
                            <button
                                type="button"
                                class="btn btn-outline-danger"
                                title="Excluir Agência"
                                data-bs-toggle="modal"
                                data-bs-target="#deleteAgenciaModal"
                                wire:click="$emit('abrirDeleteAgenciaModal', '{{ $agencia->uuid }}')"
                            >
                                <ion-icon name="trash-outline"></ion-icon> Excluir
                            </button>
                            @endif

                        </div>

                    </td>
                </tr>
                @empty
                    <tr>
                        <td colspan="7">Nenhum registro encontrado.</td>
                    </tr>
                @endforelse
                </tbody>
            </table>
        </div><!-- /responsive table -->

    </div><!-- /cardbody -->

    <livewire:agencia-financeira.create-agencia-modal />
    <livewire:agencia-financeira.update-agencia-modal />
    <livewire:agencia-financeira.delete-agencia-modal />
</div>
