@extends('layouts.admin.admin')

@include('layouts.admin._includes._pageTitleAndSubTitle')

@section('conteudo')

    <div class="card">

        <div class="card-header">
            <a href="#" class="btn icon icon-left btn-primary">
                <i data-feather="plus-circle" width="20"></i>
                Adicionar uma Nova Notícia
            </a>
        </div>

        <div class="card-body">

            <table class="table" style="color: #000;">
                <thead>
                <th>Cnpj</th>
                <th>Nome</th>
                <th>Situação</th>
                <th>Cidade</th>
                <th>Lotes</th>
                </thead>
                <tbody>
                @forelse($instituicoes as $instituicao)
                    <tr>
                        <td>{{ $instituicao->nome }}</td>
                        <td>{{ $instituicao->cnpj }}</td>
                        <td>
                            <span class="badge {{ $instituicao->situacao ? 'bg-success' : 'bg-warning' }}">
                                {{ \App\Enums\SituacaoInstituicaoEnum::getDescription( (int) $instituicao->situacao) }}
                            </span>
                        </td>
                        <td>{{ $instituicao->cidade->nome }}</td>
                        <td>

                            <a class="btn btn-outline-dark" href="">
                                <i data-feather="briefcase" width="20"></i> Prestadores
                            </a>

                            <a class="btn btn-outline-primary" href="">
                                <i data-feather="layers" width="20"></i> Lotes {{ count($instituicao->lotes) }}
                            </a>

                            <button
                                type="button"
                                class="btn btn-outline-secondary block"
                                data-bs-toggle="modal"
                                data-bs-target="#instituicaoModalCenter_{{ $instituicao->id }}">
                                <i data-feather="eye" width="20"></i> Detalhes
                            </button>

                            <div class="modal fade" id="instituicaoModalCenter_{{ $instituicao->id }}" tabindex="-1" aria-labelledby="instituicaoModalCenterTitle" style="display: none;" aria-hidden="true">
                                <div class="modal-dialog modal-dialog-centered modal-dialog-centered modal-dialog-scrollable" role="document">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="instituicaoModalCenterTitle">
                                                {{ $instituicao->nome }}
                                            </h5>
                                            <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-x"><line x1="18" y1="6" x2="6" y2="18"></line><line x1="6" y1="6" x2="18" y2="18"></line></svg>
                                            </button>
                                        </div>
                                        <div class="modal-body">

                                            <table class="table">
                                                <tr>
                                                    <th>Databse ID</th>
                                                    <td>{{ $instituicao->id }}</td>
                                                </tr>
                                                <tr>
                                                    <th>CNPJ</th>
                                                    <td>{{ $instituicao->cnpj }}</td>
                                                </tr>
                                                <tr>
                                                    <th>Situação</th>
                                                    <td>
                                                        <span class="badge {{ $instituicao->situacao ? 'bg-success' : 'bg-warning' }}">
                                {{ \App\Enums\SituacaoInstituicaoEnum::getDescription( (int) $instituicao->situacao) }}
                            </span>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th>Link de Acesso ao Sistema</th>
                                                    <td>{{ $instituicao->link_acesso_sistema }}</td>
                                                </tr>
                                            </table>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-light-secondary" data-bs-dismiss="modal">
                                                <i class="bx bx-x d-block d-sm-none"></i>
                                                <span class="d-none d-sm-block">Fechar</span>
                                            </button>
{{--                                            <button type="button" class="btn btn-primary ml-1" data-bs-dismiss="modal">--}}
{{--                                                <i class="bx bx-check d-block d-sm-none"></i>--}}
{{--                                                <span class="d-none d-sm-block">Accept</span>--}}
{{--                                            </button>--}}
                                        </div>
                                    </div>
                                </div>
                            </div>





                        </td>
                    </tr>

                @empty
                    <tr>
                        <td>Não há instituições cadastradas.</td>
                    </tr>
                @endforelse
                </tbody>
            </table>

        </div>
    </div>

@endsection

@section('scripts')
    <script>

    </script>
@stop
