<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateNotaFiscalServicosTable extends Migration
{

    public function up()
    {
        Schema::create('nota_fiscal_servico', function (Blueprint $table) {
            $table->id();
            $table->text('descricao');
            $table->string('numero');
            $table->string('numero_substituicao')->nullable();
            $table->string('codigo_verificacao');
            $table->string('numero_processo')->nullable();
            $table->integer('situacao');
            $table->dateTime('data_emissao');
            $table->dateTime('competencia');
            $table->integer('competencia_mes');
            $table->integer('competencia_ano');
            $table->decimal('valor', 10,2);
            $table->decimal('valor_iss', 10,2)->nullable();
            $table->decimal('base_calculo', 10,2)->nullable();
            $table->decimal('valor_liquido', 10,2)->nullable();
            $table->decimal('deducao_legal', 10,2)->nullable();
            $table->decimal('valor_pis', 10,2)->nullable();
            $table->decimal('valor_irrf', 10,2)->nullable();
            $table->decimal('valor_confins', 10,2)->nullable();
            $table->decimal('valor_csll', 10,2)->nullable();
            $table->decimal('valor_inss', 10,2)->nullable();
            $table->decimal('outras_retencoes', 10,2)->nullable();
            $table->decimal('aliquota', 10,2)->nullable();
            $table->dateTime('data_cancelamento')->nullable();
            $table->integer('exigibilidade_iss');
            $table->integer('retencao_iss');

            $table->integer('regime_tributacao_prestador');
            $table->boolean('optante_simples_prestador');
            $table->decimal('desconto_condicionado', 10,2)->nullable();
            $table->decimal('desconto_incondicionado', 10,2)->nullable();
            $table->integer('pais_incidencia');

            $table->timestamps();

            $table->unsignedBigInteger('id_prestador')->nullable();
            $table->foreign('id_prestador')
                ->references('id')->on('prestador')
                ->onDelete('cascade');

            $table->unsignedBigInteger('id_tomador')->nullable();
            $table->foreign('id_tomador')
                ->references('id')->on('tomador')
                ->onDelete('cascade');

            $table->unsignedBigInteger('id_atividade')->nullable();
            $table->foreign('id_atividade')
                ->references('id')->on('atividade_economica')
                ->onDelete('cascade');

            $table->unsignedBigInteger('id_instituicao')->nullable();
            $table->foreign('id_instituicao')
                ->references('id')->on('instituicao')
                ->onDelete('cascade');

            $table->unsignedBigInteger('id_cidade_prestacao')->nullable();
            $table->foreign('id_cidade_prestacao')
                ->references('id')->on('cidades')
                ->onDelete('cascade');

            $table->unsignedBigInteger('id_cidade_incidencia')->nullable();
            $table->foreign('id_cidade_incidencia')
                ->references('id')->on('cidades')
                ->onDelete('cascade');

            $table->unsignedBigInteger('id_dam')->nullable();
            $table->foreign('id_dam')
                ->references('id')->on('dam')
                ->onDelete('cascade');

            $table->unsignedBigInteger('id_prestador_nota')->nullable();
            $table->foreign('id_prestador_nota')
                ->references('id')->on('prestador_nota_fiscal')
                ->onDelete('cascade');

            $table->unsignedBigInteger('id_tomador_nota')->nullable();
            $table->foreign('id_tomador_nota')
                ->references('id')->on('tomador_nota_fiscal')
                ->onDelete('cascade');

            $table->unsignedBigInteger('id_dam_avulso_externo')->nullable();
            $table->foreign('id_dam_avulso_externo')
                ->references('id')->on('dam_avulso_externo')
                ->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('nota_fiscal_servico');
    }
}
