<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateLotesRpsNotaFiscalServicosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('lotes_rps_nota_fiscal_servico', function (Blueprint $table) {
            $table->id();

            $table->unsignedBigInteger('id_lote')->nullable();
            $table->foreign('id_lote')
                ->references('id')->on('lotes')
                ->onDelete('cascade');

            $table->unsignedBigInteger('id_rps')->nullable();
            $table->foreign('id_rps')
                ->references('id')->on('rps')
                ->onDelete('cascade');

            $table->unsignedBigInteger('id_nota')->nullable();
            $table->foreign('id_nota')
                ->references('id')->on('nota_fiscal_servico')
                ->onDelete('cascade');

            $table->timestamps();

            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('lotes_rps_nota_fiscal_servico');
    }
}
