<?php

use App\Enums\StatusEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateLotesTable extends Migration
{
    public function up()
    {
        Schema::create('lotes', function (Blueprint $table) {
            $table->id();
            $table->string('lote_rps_id');
            $table->string('numero');
            $table->string('cnpj');
            $table->string('inscricao_municipal');
            $table->integer('quantidade_rps');
            $table->tinyInteger('status')->unsigned()->default(StatusEnum::NORMAL);

            $table->softDeletes();
            $table->timestamps();

            $table->unsignedBigInteger('instituicao_id')->nullable();
            $table->foreign('instituicao_id')
                ->references('id')->on('instituicao')
                ->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('lotes');
    }
}
