<?php

namespace App\Validadores\LoteRps;

use App\Enums\SituacaoInstituicaoEnum;
use App\Models\Instituicao;
use App\Models\Lote;
use Exception;

class InstituicaoInvalida extends AbstractLoteRpsValidator
{
     /**
     * @param Lote $lote
     * @return mixed
     * @throws Exception
     */
    public function validar(Lote $lote)
    {
        $instituicao = Instituicao::find($lote->instituicao_id);

        if (!$instituicao)
            throw new Exception("Instituição não cadastrado neste Webservice.");

        if ($instituicao->situacao == SituacaoInstituicaoEnum::INATIVO)
            throw new Exception("Instituição com status Inativo para este Webservice.");

        return $this->proximoLote->validar($lote);
    }
}
