<?php

namespace App\Traits;

use App\Models\Prestador;
use App\Scopes\PrestadorTenantScope;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

trait PrestadorTenantable
{
    protected static function booted()
    {
        parent::boot();

        static::addGlobalScope(new PrestadorTenantScope());

        if (existsInSessionPrestadorTenantId()) {
            static::creating(static function ($model) {
                $model->prestador_id = session('prestador_id');
            });
        }
    }

//    protected static function bootPrestadorTenanteble()
//    {
//        static::addGlobalScope(new PrestadorTenantScope());
//
//        if (existsInSessionPrestadorTenantId()) {
//            static::creating(function ($model) {
//                $model->prestador_id = session('prestador_id');
//            });
//        }
//    }

    public function prestador() : BelongsTo
    {
        return $this->belongsTo(Prestador::class);
    }
}
