<?php

namespace App\Services\Tomador;

use App\Models\Tomador;
use PHPUnit\Exception;

class CriaTomador
{
    private int $id_dados_cadastrais;
    private int $id_prestador;
    private int $id_instituicao;

    /**
     * @param $id_dados_cadastrais
     * @param $id_prestador
     * @param $id_instituicao
     */
    public function __construct($id_dados_cadastrais, $id_prestador, $id_instituicao)
    {
        $this->id_dados_cadastrais = $id_dados_cadastrais;
        $this->id_prestador = $id_prestador;
        $this->id_instituicao = $id_instituicao;
    }

    public function criar()
    {
        try {
            $tomador = Tomador::create([
                'id_dados_cadastrais' => $this->id_dados_cadastrais,
                'id_prestador' => $this->id_prestador,
                'id_instituicao' => $this->id_instituicao
            ]);

            return $tomador;

        } catch (Exception $exception) {
            return $exception->getMessage() . ' - Linha: ' . $exception->getLine();
        }
    }
}
