<?php

namespace App\Services\Notas;

use App\Models\NotaFiscalServico;

class NotaPersist
{
    /**
     * @param array $dadosParaNota
     * @return NotaFiscalServico
     * @throws \Exception
     */
    public static function store(array $dadosParaNota) : NotaFiscalServico
    {
        try {
            $notaServico = new NotaFiscalServico();
            $notaServico->fill($dadosParaNota);
            $notaServico->save();

            return $notaServico;

        } catch (\Exception $exception) {
            throw new \Exception("Problemas ao tentar salvar a Nota Fiscal no Banco de Dados." . $exception->getMessage());
        }
    }
}
