<?php

namespace App\Services\Notas;

use App\Models\LotesRpsNotaFiscalServico;

class CriaRelacionamentoLoteRpsNota
{
    /**
     * @param $lote_id
     * @param $rps_id
     * @param $nota_id
     * @throws \Exception
     */
    public static function criar($lote_id, $rps_id, $nota_id)
    {
        $relacionamentoCriado = LotesRpsNotaFiscalServico::create([
            'id_lote' => $lote_id,
            'id_rps' => $rps_id,
            'id_nota' => $nota_id
        ]);

        if (!$relacionamentoCriado)
            throw new \Exception("Erro ao tentar criar o relacionamente entre: Lotes, Rps e Notas Fiscais."
                . get_class(CriaRelacionamentoLoteRpsNota::class));
    }
}
