<?php

namespace App\Services;

class GeradorDeAnoMesDiasHorasEMinutos
{
    public static function gerarAnos() : array
    {
        $anos = [];

        $ano_atual = date('Y');

        for ($i = $ano_atual; $i > ($ano_atual - 5); $i--) {
            $anos[] = $i;
        }

        return $anos;
    }

    /**
     * @return array
     */
    public static function gerarMeses(): array
    {
        $meses = [];

        for ($i = 1; $i <= 12; $i++) {
            $meses[] = str_pad( (string) $i, 2, '0', STR_PAD_LEFT);
        }

        return $meses;
    }

    /**
     * @return array
     */
    public static function gerarHoras(): array
    {
        $horas = [];

        for ($i = 0; $i <= 23; $i++) {
            $horas[] = str_pad( (string) $i, 2, '0', STR_PAD_LEFT);
        }

        return $horas;
    }

    /**
     * @return array
     */
    public static function gerarMinutos(): array
    {
        $minutos = [];

        $i = 0;

        while ($i < 60) {
            $minutos[] = str_pad( (string) $i, 2, '0', STR_PAD_LEFT);
            $i = $i + 5;
        }

        return $minutos;
    }
}
