<?php

namespace App\Services\Balancete;

use App\Models\InstituicaoFinanceira\LancamentosFinanceiro;
use Illuminate\Database\Eloquent\Model;

class CalculadoraValorDamBalancete
{
    public function __construct(
        private Model $balancete,
        private bool $estaNoPrazo,
        private float $porcentagemMulta
    )
    {}

    public function obterValor()
    {
        $valorIssMes = $this->calcularIssMesParaUmBalancete();

        if ($this->estaNoPrazo) {
            return $valorIssMes;
        }

        $valorMulta = $this->porcentagemMulta / 100 * $valorIssMes;

        return $valorIssMes + $valorMulta;
    }

    private function calcularIssMesParaUmBalancete()
    {
        return LancamentosFinanceiro::where('balancete_id', $this->balancete->id)
            ->where('deleted_at', null)
            ->sum('calculo_iss_mes');
    }
}
