<?php

namespace App\Services\AtividadeEconomica;

class FormatadorCodigoCnae
{
    /**
     * Responsável pela formatação código CNAE recebido no xml para o padrão utilizado no Banco de Dados.
     * Isso apenas ocorrerá caso o valor recebido não esteja formatada.
     * String recebida do xml: 4520001
     * String Formatada para presquisar no banco de dados: 4520-0/01
     *
     * @param $codigoVindoNoXml
     * @return mixed|string
     */
    public static function formatar($codigoVindoNoXml)
    {
        if (strpos($codigoVindoNoXml, '/') && strpos($codigoVindoNoXml, '-'))
            return $codigoVindoNoXml;

        $cnaeFormatado = substr($codigoVindoNoXml, 0, -3);
        $cnaeFormatado .= "-";
        $cnaeFormatado .= substr($codigoVindoNoXml,  -3, 1);
        $cnaeFormatado .= "/";
        $cnaeFormatado .= substr($codigoVindoNoXml,  -2, 2);

        return $cnaeFormatado;
    }
}
