<?php

namespace App\Providers;

use App\Events\PrestadorInsituicaoTenantIdEvent;
use App\Http\Controllers\InstituicaoFinanceira\AutenticadorInstituicaoFinanceiraController;
use App\Listeners\SetPrestadorTenantIdInSessionListener;
use Illuminate\Auth\Events\Registered;
use Illuminate\Auth\Listeners\SendEmailVerificationNotification;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Event;

class EventServiceProvider extends ServiceProvider
{
    /**
     * The event listener mappings for the application.
     *
     * @var array
     */
    protected $listen = [
        Registered::class => [
            SendEmailVerificationNotification::class,
        ],
        PrestadorInsituicaoTenantIdEvent::class => [
            SetPrestadorTenantIdInSessionListener::class
        ],
    ];

    /**
     * Register any events for your application.
     *
     * @return void
     */
    public function boot()
    {
        //
    }
}
