<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Rps extends Model
{
    use HasFactory;

    use SoftDeletes;

    protected $table = "rps";

    protected $fillable = [
        'rps_id',
        'numero',
        'serie',
        'tipo',
        'data_emissao',
        'natureza_operacao',
        'regime_especial_tributacao',
        'optante_simples_nacional',
        'incentivador_cultural',
        'competencia',
        'status',

        'valor_servicos',
        'valor_deducoes',
        'valor_pis',
        'valor_cofins',
        'valor_inss',
        'valor_ir',
        'valor_csll',
        'valor_iss_retido',
        'retencao_iss',
        'valor_iss',
        'outras_retencoes',
        'aliquota',
        'desconto_incondicionado',
        'desconto_condicionado',

        'item_listaServico',
        'codigo_cnae',
        'codigo_tributacao_municipio',

        'discriminacao',
        'codigo_municipio',

        'cpf_cnpj_tomador',
        'razao_social_tomador',
        'endereco_tomador',
        'numero_tomador',
        'complemento_tomador',
        'bairro_tomador',
        'codigo_municipal_tomador',
        'uF_tomador',
        'cep_tomador',
        'telefone_tomador',
        'email_tomador',

        'lote_id'
    ];

    public function lote()
    {
        return $this->belongsTo(Lote::class, 'lote_id');
    }

    public function loteRpsNota()
    {
        return $this->hasMany(LotesRpsNotaFiscalServico::class);
    }
}
