<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Lote extends Model
{
    use HasFactory;

    use SoftDeletes;

    protected $fillable = [
        'lote_rps_id',
        'numero',
        'cnpj',
        'inscricao_municipal',
        'codigo_cidade_cadastro_prestador',
        'quantidade_rps',
        'status',

        'instituicao_id'
    ];
    /**
     * @var mixed
     */

    public function rps()
    {
        return $this->hasMany(Rps::class);
    }

    public function loteNota()
    {
        return $this->hasMany(LotesRpsNotaFiscalServico::class, 'id_lote');
    }

    public function instituicao()
    {
        return $this->belongsTo(Instituicao::class, 'instituicao_id');
    }
}
