<?php

namespace App\Http\Livewire\AgenciaFinanceira__old;

use App\Enums\StatusPadraoEnum;
use App\Models\InstituicaoFinanceira\AgenciasFinanceiras;
use App\Models\InstituicaoFinanceira\InstituicaoFinanceira;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Session;
use Livewire\Component;
use PHPUnit\Exception;

class UpdateAgenciaModal extends Component
{
    public $showForm;
    public $alert;

    public $uuid;
    public $nome;
    public $codigo;
    public $cnpj;
    public $status;
    public $instituicao_financeira_id;
    public $observacoes;

    protected $listeners = ['abrirEditAgenciaModal'];

    protected $rules = [
        'instituicao_financeira_id' => 'required',
        'nome' => 'required|string|min:5|max:255',
        'codigo' => 'required',
        'cnpj' => 'required|cnpj',
    ];

    public function updated($propertyName)
    {
        $this->validateOnly($propertyName);
    }

    public function render()
    {
        $instituicoesFinanceiras = InstituicaoFinanceira::where('status', StatusPadraoEnum::ATIVO)->get();
        $statusAgecias = StatusPadraoEnum::asSelectArray();

        return view('livewire.agencia-financeira.update-agencia-modal', compact('instituicoesFinanceiras', 'statusAgecias'));
    }

    public function abrirEditAgenciaModal(string $agencia_uuid)
    {
        $this->alert = [];
        $this->showForm = true;

        $this->uuid = $agencia_uuid;

        $agencia = AgenciasFinanceiras::where('uuid', $this->uuid)->first();

        $this->nome = $agencia->nome;
        $this->codigo = $agencia->codigo;
        $this->cnpj = $agencia->cnpj;
        $this->instituicao_financeira_id = $agencia->instituicao_financeira_id;
        $this->observacoes = $agencia->observacoes;
        $this->status = $agencia->status;
    }

    public function submit()
    {
        $this->validate();
        sleep(1);
        $this->updateAgencia();
    }

    public function updateAgencia()
    {
        try {

            DB::beginTransaction();

            $agencia_log_antes = $agencia = AgenciasFinanceiras::where('uuid', $this->uuid)->first();

            $agencia = AgenciasFinanceiras::where('uuid', $this->uuid)
                ->update([
                    'nome'                          => $this->nome,
                    'codigo'                        => $this->codigo,
                    'cnpj'                          => $this->cnpj,
                    'observacoes'                   => $this->observacoes,
                    'instituicao_financeira_id'     => $this->instituicao_financeira_id,
                    'status'                        => $this->status,
                ]);

            $agencia_log_depois = $agencia = AgenciasFinanceiras::where('uuid', $this->uuid)->first();

            $prestador_id = Session::get('prestador')->id;

            Log::info("Agência Financeira de ID {$agencia->id} atualizada pelo Prestador de id {$prestador_id}", [
                'antes' => $agencia_log_antes,
                'depois' => $agencia_log_depois,
            ]);

            DB::commit();

            $this->showForm = false;

            $this->alert = [
                'show' => true,
                'type' => 'success',
                'title' => 'Sucesso!',
                'description' => "Agência " . $agencia->nome . " Atualizada com sucesso."
            ];

            $this->emitTo('agencia-financeira.agencia-index', '$refresh');

        } catch (Exception $exception) {
            DB::rollBack();
            Log::error("Atualizando Agência Financeira: " . $exception->getMessage());

            $this->alert = [
                'show' => true,
                'type' => 'danger',
                'title' => 'Erro!',
                'description' => "Houve um problema durante o procedimento e não foi possível atualizar a agência {$this->nome}."
            ];
        }
    }
}
