<?php

namespace App\Http\Livewire\AgenciaFinanceira__old;

use App\Enums\StatusPadraoEnum;
use App\Models\InstituicaoFinanceira\AgenciasFinanceiras;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Session;
use Livewire\Component;
use PHPUnit\Exception;

class DeleteAgenciaModal extends Component
{
    public $alert;
    public $showFormButtons;

    public $nome;
    public $codigo;
    public string $uuid;
    public $cnpj;
    public $agencia;
    public $observacoes;

    protected $listeners = ['abrirDeleteAgenciaModal'];

    public function render()
    {
        return view('livewire.agencia-financeira.delete-agencia-modal');
    }

    public function abrirDeleteAgenciaModal(string $agencia_uuid)
    {
        $this->alert = [];
        $this->showFormButtons = true;

        $this->uuid = $agencia_uuid;

        $this->agencia = AgenciasFinanceiras::where('uuid', $this->uuid)->first();

        $this->nome         = $this->agencia->nome;
        $this->codigo       = $this->agencia->codigo;
        $this->cnpj         = $this->agencia->cnpj;
        $this->observacoes  = $this->agencia->observacoes;
    }

    public function excluirAgencia()
    {
        $agencia_log_a_excluir = $this->agencia;

        try {

            DB::beginTransaction();

            $this->agencia->delete();

            $prestador_id = Session::get('prestador')->id;

            Log::info("Agência Financeira Excluída pelo Prestador de id {$prestador_id}", $agencia_log_a_excluir->toArray());

            DB::commit();

            $this->showFormButtons = false;

            $this->alert = [
                'show' => true,
                'type' => 'success',
                'title' => 'Sucesso!',
                'description' => "Agência {$agencia_log_a_excluir->nome} Excluída com sucesso."
            ];

            $this->emitTo('agencia-financeira.agencia-index', '$refresh');

        } catch (Exception $exception) {
            DB::rollBack();
            Log::error("Exclusão Agência Financeira: " . $exception->getMessage());

            $this->alert = [
                'show' => true,
                'type' => 'danger',
                'title' => 'Erro!',
                'description' => "Houve um problema durante o procedimento e não foi possível excluir a agência {$agencia_log_a_excluir->nome}."
            ];
        }
    }
}
