<?php

namespace App\Events;

use App\Models\Instituicao;
use App\Models\Prestador;
use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PresenceChannel;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class PrestadorInsituicaoTenantIdEvent
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    private Instituicao $instituicao;
    private Prestador $prestador;

    /**
     * Create a new event instance.
     *
     * @return void
     */
    /**
     * @param Instituicao $instituicao
     * @param Prestador $prestador
     */
    public function __construct(Instituicao $instituicao, Prestador $prestador)
    {
        //
        $this->instituicao = $instituicao;
        $this->prestador = $prestador;
    }

    public function getInstituicao(): Instituicao
    {
        return $this->instituicao;
    }

    public function getPrestador(): Prestador
    {
        return $this->prestador;
    }

    /**
     * Get the channels the event should broadcast on.
     *
     * @return \Illuminate\Broadcasting\Channel|array
     */
    public function broadcastOn()
    {
        return new PrivateChannel('channel-name');
    }
}
