<?php

namespace App\Enums;

use BenSampo\Enum\Enum;

final class StatusEnum extends Enum
{
    const NORMAL =   1;
    const CANCELADO =   2;

    public static function getDescription($value): string
    {
        if ($value === self::NORMAL) {
            return 'Normal';
        }

        if ($value === self::CANCELADO) {
            return 'Cancelado';
        }

        return parent::getDescription($value);
    }
}
